-- For table REGION
ALTER TABLE TPCH.REGION
ADD CONSTRAINT pk_region PRIMARY KEY (R_REGIONKEY);

-- For table NATION
ALTER TABLE TPCH.NATION
ADD CONSTRAINT pk_nation PRIMARY KEY (N_NATIONKEY);

ALTER TABLE TPCH.NATION
ADD CONSTRAINT fk_nation_region FOREIGN KEY (N_REGIONKEY) REFERENCES TPCH.REGION (R_REGIONKEY);

-- For table PART
ALTER TABLE TPCH.PART
ADD CONSTRAINT pk_part PRIMARY KEY (P_PARTKEY);

-- For table SUPPLIER
ALTER TABLE TPCH.SUPPLIER
ADD CONSTRAINT pk_supplier PRIMARY KEY (S_SUPPKEY);

ALTER TABLE TPCH.SUPPLIER
ADD CONSTRAINT fk_supplier_nation FOREIGN KEY (S_NATIONKEY) REFERENCES TPCH.NATION (N_NATIONKEY);

-- For table PARTSUPP
DELETE FROM TPCH.PARTSUPP
WHERE ctid NOT IN (
    SELECT MIN(ctid)
    FROM TPCH.PARTSUPP
    GROUP BY PS_PARTKEY, PS_SUPPKEY
);

ALTER TABLE TPCH.PARTSUPP
ADD CONSTRAINT pk_partsupp PRIMARY KEY (PS_PARTKEY, PS_SUPPKEY);

ALTER TABLE TPCH.PARTSUPP
ADD CONSTRAINT fk_partsupp_supplier FOREIGN KEY (PS_SUPPKEY) REFERENCES TPCH.SUPPLIER (S_SUPPKEY);

ALTER TABLE TPCH.PARTSUPP
ADD CONSTRAINT fk_partsupp_part FOREIGN KEY (PS_PARTKEY) REFERENCES TPCH.PART (P_PARTKEY);

-- For table CUSTOMER
ALTER TABLE TPCH.CUSTOMER
ADD CONSTRAINT pk_customer PRIMARY KEY (C_CUSTKEY);

ALTER TABLE TPCH.CUSTOMER
ADD CONSTRAINT fk_customer_nation FOREIGN KEY (C_NATIONKEY) REFERENCES TPCH.NATION (N_NATIONKEY);

-- For table ORDERS
ALTER TABLE TPCH.ORDERS
ADD CONSTRAINT pk_orders PRIMARY KEY (O_ORDERKEY);

ALTER TABLE TPCH.ORDERS
ADD CONSTRAINT fk_orders_customer FOREIGN KEY (O_CUSTKEY) REFERENCES TPCH.CUSTOMER (C_CUSTKEY);

-- For table LINEITEM
ALTER TABLE TPCH.LINEITEM
ADD CONSTRAINT pk_lineitem PRIMARY KEY (L_ORDERKEY, L_LINENUMBER);

ALTER TABLE TPCH.LINEITEM
ADD CONSTRAINT fk_lineitem_orders FOREIGN KEY (L_ORDERKEY) REFERENCES TPCH.ORDERS (O_ORDERKEY);

ALTER TABLE TPCH.LINEITEM
ADD CONSTRAINT fk_lineitem_partsupp FOREIGN KEY (L_PARTKEY, L_SUPPKEY) REFERENCES TPCH.PARTSUPP (PS_PARTKEY, PS_SUPPKEY);